s->get('Errors')))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		// Display the template
		parent::display($tpl);

		// Set the document
		$this->setDocument();
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar()
	{
		JToolBarHelper::title(JText::_('COM_HILATION_RELATIONS'), 'joomla');
		JHtmlSidebar::setAction('index.php?option=com_hilation&view=relations');
		JFormHelper::addFieldPath(JPATH_COMPONENT . '/models/fields');

		if ($this->canCreate)
		{
			JToolBarHelper::addNew('relation.add');
		}

		// Only load if there are items
		if (HilationHelper::checkArray($this->items))
		{
			if ($this->canEdit)
			{
				JToolBarHelper::editList('relation.edit');
			}

			if ($this->canState)
			{
				JToolBarHelper::publishList('relations.publish');
				JToolBarHelper::unpublishList('relations.unpublish');
				JToolBarHelper::archiveList('relations.archive');

				if ($this->canDo->get('core.admin'))
				{
					JToolBarHelper::checkin('relations.checkin');
				}
			}

			// Add a batch button
			if ($this->canBatch && $this->canCreate && $this->canEdit && $this->canState)
			{
				// Get the toolbar object instance
				$bar = JToolBar::getInstance('toolbar');
				// set the batch button name
				$title = JText::_('JTOOLBAR_BATCH');
				// Instantiate a new JLayoutFile instance and render the batch button
				$layout = new JLayoutFile('joomla.toolbar.batch');
				// add the button to the page
				$dhtml = $layout->render(array('title' => $title));
				$bar->appendButton('Custom', $dhtml, 'batch');
			}

			if ($this->state->get('filter.published') == -2 && ($this->canState && $this->canDelete))
			{
				JToolbarHelper::deleteList('', 'relations.delete', 'JTOOLBAR_EMPTY_TRASH');
			}
			elseif ($this->canState && $this->canDelete)
			{
				JToolbarHelper::trash('relations.trash');
			}

			if ($this->canDo->get('core.export') && $this->canDo->get('relation.export'))
			{
				JToolBarHelper::custom('relations.exportData', 'download', '', 'COM_HILATION_EXPORT_DATA', true);
			}
		}

		if ($this->canDo->get('core.import') && $this->canDo->get('relation.import'))
		{
			JToolBarHelper::custom('relations.importData', 'upload', '', 'COM_HILATION_IMPORT_DATA', false);
		}

		// set help url for this view if found
		$help_url = HilationHelper::getHelpUrl('relations');
		if (HilationHelper::checkString($help_url))
		{
				JToolbarHelper::help('COM_HILATION_HELP_MANAGER', false, $help_url);
		}

		// add the options comp button
		if ($this->canDo->get('core.admin') || $this->canDo->get('core.options'))
		{
			JToolBarHelper::preferences('com_hilation');
		}

		// Only load published batch if state and batch is allowed
		if ($this->canState && $this->canBatch)
		{
			JHtmlBatch_::addListSelection(
				JText::_('COM_HILATION_KEEP_ORIGINAL_STATE'),
				'batch[published]',
				JHtml::_('select.options', JHtml::_('jgrid.publishedOptions', array('all' => false)), 'value', 'text', '', true)
			);
		}

		// Only load access batch if create, edit and batch is allowed
		if ($this->canBatch && $this->canCreate && $this->canEdit)
		{
			JHtmlBatch_::addListSelection(
				JText::_('COM_HILATION_KEEP_ORIGINAL_ACCESS'),
				'batch[access]',
				JHtml::_('select.options', JHtml::_('access.assetgroups'), 'value', 'text')
			);
		}
	}

	/**
	 * Method to set up the document properties
	 *
	 * @return void
	 */
	protected function setDocument()
	{
		if (!isset($this->document))
		{
			$this->document = JFactory::getDocument();
		}
		$this->document->setTitle(JText::_('COM_HILATION_RELATIONS'));
		$this->document->addStyleSheet(JURI::root() . "administrator/components/com_hilation/assets/css/relations.css", (HilationHelper::jVersion()->isCompatible('3.8.0')) ? array('version' => 'auto') : 'text/css');
	}

	/**
	 * Escapes a value for output in a view script.
	 *
	 * @param   mixed  $var  The output to escape.
	 *
	 * @return  mixed  The escaped value.
	 */
	public function escape($var)
	{
		if(strlen($var) > 50)
		{
			// use the helper htmlEscape method instead and shorten the string
			return HilationHelper::htmlEscape($var, $this->_charset, true);
		}
		// use the helper htmlEscape method instead.
		return HilationHelper::htmlEscape($var, $this->_charset);
	}

	/**
	 * Returns an array of fields the table can be sorted by
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value
	 */
	protected function getSortFields()
	{
		return array(
			'a.ordering' => JText::_('JGRID_HEADING_ORDERING'),
			'a.published' => JText::_('JSTATUS'),
			'a.id' => JText::_('JGRID_HEADING_ID')
		);
	}
}
PK     ✊[wtW        configmarket/index.htmlnu [        <html><body></body></html>PK     ✊[bEX      configmarket/tmpl/acl.phpnu [        <?php
/**
 * @package    HikaMarket for Joomla!
 * @version    3.1.1
 * @author     Obsidev S.A.R.L.
 * @copyright  (C) 2011-2020 OBSIDEV. All rights reserved.
 * @license    GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
defined('_JEXEC') or die('Restricted access');
?><?php
if(!empty($this->acl_type)) {
	if($this->acl_type == 'vendor_options')
		echo $this->loadTemplate('options');
	else
		echo $this->loadTemplate('edit');
	return;
}
?>
<div class="iframedoc" id="iframedoc"></div>
<div class="adminform">
	<div id="cpanel">
<?php foreach($this->buttons as $btn) { ?>
		<div class="icon-wrapper">
			<div class="icon">
				<a href="<?php echo $btn['url'];?>">
					<span class="<?php echo $btn['icon'];?>" style="background-repeat:no-repeat;background-position:center;height:48px;padding:10px 0;"></span>
					<span><?php echo $btn['name'];?></span>
				</a>
			</div>
		</div>
<?php } ?>
	<div style="clear:both"></div>
	</div>
</div>
PK     ✊[S*  *    configmarket/tmpl/acl_edit.phpnu [        <?php
/**
 * @package    HikaMarket for Joomla!
 * @version    3.1.1
 * @author     Obsidev S.A.R.L.
 * @copyright  (C) 2011-2020 OBSIDEV. All rights reserved.
 * @license    GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
defined('_JEXEC') or die('Restricted access');
?><div class="iframedoc" id="iframedoc"></div>
<form action="<?php echo hikamarket::completeLink('config'); ?>" method="post" name="adminForm" id="adminForm">
	<table id="hikamarket_acl_list" class="adminlist pad0 table table-striped table-hover">
		<thead>
			<tr>
				<th class="hikamarket_acl_name_title title" style="min-width:200px;"><?php echo JText::_('HIKA_NAME'); ?></th>
<?php
	foreach($this->groups as $group) {
?>
				<th class="hikamarket_acl_group_<?php echo $group->id; ?>_title title titletoggle"><?php echo $group->title; ?></th>
<?php
	}
?>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="<?php echo count($this->groups) + 1; ?>">
				</td>
			</tr>
		</tfoot>
		<tbody>
<?php
$k = 0