+= (float)hikamarket::toFloat($transaction->total_vendor_price);
					$vendors[ (int)$transaction->vendor_id ]->total_full_price += (float)hikamarket::toFloat($transaction->total_full_price);
				} else {
					$order->total_vendor_price = (float)hikamarket::toFloat($order->total_vendor_price);
					$order->total_full_price = (float)hikamarket::toFloat($order->total_full_price);

					$vendors[ (int)$transaction->vendor_id ]->total_vendor_price += $this->currencyHelper->convertUniquePrice($transaction->total_vendor_price, (int)$transaction->order_transaction_currency_id, $vendor_currency_id);
					$vendors[ (int)$transaction->vendor_id ]->total_full_price += $this->currencyHelper->convertUniquePrice($transaction->total_full_price, (int)$transaction->order_transaction_currency_id, $vendor_currency_id);

					if(empty($vendors[ (int)$transaction->vendor_id ]->currencies))
						$vendors[ (int)$transaction->vendor_id ]->currencies = array();
					$vendors[ (int)$transaction->vendor_id ]->currencies[(int)$transaction->order_transaction_currency_id] = array(
						'vendor' => $transaction->total_vendor_price,
						'full' => $transaction->total_full_price
					);
				}
			}
		}

		hikamarket::setTitle($title, self::icon, self::ctrl.$ctrl);
		$this->toolbar = array(
			'pay' => array('name' => 'custom', 'icon' => 'pay', 'alt' => JText::_('PAY_VENDOR'), 'task' => 'dopay'),
			array('name' => 'hikacancel', 'url' => (is_int($vendor_id) ? hikamarket::completeLink('vendor&task=edit&cid[]='.$vendor_id) : hikamarket::completeLink('vendor&task=listing')) ),
			'|',
			array('name' => 'pophelp', 'target' => self::ctrl.'-pay')
		);
		if(!$feeMode) {
			$this->toolbar['pay'] = array(
				'name' => 'custom',
				'icon' => 'invoice',
				'alt' => JText::_('GENERATE_INVOICE'),
				'task' => 'dogeninvoice'
			);
		}
	}

	public function payreport($tpl = null) {
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();
		$ctrl = '';

		$order_ids = hikaInput::get()->get('cid', array(), 'array');
		hikamarket::toInteger($order_ids);

		$this->loadRef(array(
			'popup' => 'shop.helper.popup',
			'currencyClass' => 'shop.class.currency'
		));

		$shopConfig = hikamarket::config(false);
		$created_status = $shopConfig->get('order_created_status', 'created');
		$this->assignRef('created_status', $created_status);

		$order_types = array('vendorpayment', 'sale');
		foreach($order_types as &$order_type) {
			$order_type = $db->Quote($order_type);
		}
		unset($order_type);

		$query = 'SELECT v.*, o.* FROM ' . hikamarket::table('shop.order') . ' AS o '.
				' INNER JOIN ' . hikamarket::table('vendor') . ' AS v ON o.order_vendor_id = v.vendor_id '.
				' WHERE o.order_type IN ('.implode(',', $order_types).') AND o.order_id IN ('.implode(',', $order_ids).')';
		$db->setQuery($query);
		$orders = $db->loadObjectList('order_id');
		$this->assignRef('orders', $orders);

		$cancelUrl = urlencode(base64_encode(hikamarket::completeLink('vendor&task=pay&report=1&cid='.implode('&cid=', $order_ids))));
		$this->assignRef('cancelUrl', $cancelUrl);

		hikamarket::setTitle(JText::_('VENDOR_PAY_REPORT'), self::icon, self::ctrl.$ctrl.'&task=pay&report=1&cid[]=' . implode('&cid[]=', $order_ids));
		$this->toolbar = array(
			array('name' => 'hikacancel', 'url' => hikamarket::completeLink('vendor&task=listing')),
			'|',
			array('name' => 'pophelp', 'target' => self::ctrl.'-pay')
		);
	}

	public function paymanual($tpl = null) {
		$app = JFactory::getApplication();
		$config = hikamarket::config();
		$shopConfig = hikamarket::config(false);

		$vendor_id = hikamarket::getCID('vendor_id');
		$order_id = hikaInput::get()->getInt('order_id', 0);


		$this->loadRef(array(
			'vendorClass' => 'class.vendor',
			'orderClass' => 'class.order',
			'currencyClass' => 'shop.class.currency',
		));

		$order = $this->orderClass->getRaw($order_id);
		$this->assignRef('order', $order);

		$payment_method = hikaInput::get()->getString('payment_method', 'manual');
		$this->assignRef('payment_method', $payment_method);

		$vendor = $this->vendorClass->get($vendor_id);
		$this->assignRef('vendor', $vendor);

		if(($order->order_vendor_id != $vendor->vendor_id) || $order->order_type != 'vendorpayment') {
			$app->enqueueMessage(JText::_('INVALID_DATA'), 'error');
			return false;
		}

		$created_status = $shopConfig->get('order_created_status', 'created');
		$confirmed_status = $shopConfig->get('order_confirmed_status', 'confirmed');
		if($order->order_status == $confirmed_status) {
			$app->enqueueMessage(JText::_('HIKAM_ORDER_ALREADY_PAID'));
			return false;
		}

		$thi